<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Detail Task</h6>
      </div>
      <div class="card-body">
        <div class="mb-3">
          <strong>Nama Task:</strong> <?php echo e($task->name); ?>

        </div>
        <div class="mb-3">
          <strong>Link GitLab:</strong> 
          <?php if($task->link_gitlab): ?>
            <a href="<?php echo e($task->link_gitlab); ?>" target="_blank" class="text-info"><?php echo e($task->link_gitlab); ?> <i class="fas fa-external-link-alt text-xs ms-1"></i></a>
          <?php else: ?>
            -
          <?php endif; ?>
        </div>
        <div class="mb-3">
          <strong>Status:</strong> <?php echo e($task->status); ?>

        </div>
        <div class="mb-3">
          <strong>Target Date:</strong> <?php echo e(\Illuminate\Support\Carbon::parse($task->target_date)->format('d M Y')); ?>

        </div>
        <div class="mb-3">
          <strong>Jenis Task:</strong> <?php echo e(implode(', ', $task->types ?? [])); ?>

        </div>
        <div class="mb-3">
          <strong>Frekuensi Reminder (jam):</strong> <?php echo e($task->reminder_frequency_hours); ?>

        </div>
        <div class="mb-3">
          <strong>Email Tujuan Reminder:</strong> <?php echo e(implode(', ', $task->reminder_emails ?? ($task->reminder_email ? [$task->reminder_email] : []))); ?>

        </div>
        <div class="mb-3">
          <strong>Terakhir Reminder:</strong> <?php echo e($task->last_reminded_at ? \Illuminate\Support\Carbon::parse($task->last_reminded_at)->format('d M Y H:i') : '-'); ?>

        </div>
        <div class="mb-3">
          <strong>Tanggal Pencatatan:</strong> <?php echo e($task->recorded_at ? \Illuminate\Support\Carbon::parse($task->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($task->created_at)->format('d M Y')); ?>

        </div>
        <div class="d-flex justify-content-end">
          <a href="<?php echo e(route('tasks.index')); ?>" class="btn btn-light">Kembali</a>
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-tasks')): ?>
          <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="btn btn-primary ms-2" data-confirm="Masuk ke halaman edit task?">Edit</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user_type.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/tryprasetyoadi/Documents/cubi/soft-ui-dashboard-laravel/resources/views/tasks/show.blade.php ENDPATH**/ ?>