<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Tambah Reminder Stakeholder</h6>
      </div>
      <div class="card-body">
        <form method="POST" action="<?php echo e(route('stakeholders.store')); ?>">
          <?php echo csrf_field(); ?>
          <div class="mb-3">
            <label class="form-label">Judul</label>
            <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Target Date</label>
            <input type="date" class="form-control" name="target_date" value="<?php echo e(old('target_date')); ?>" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Jenis</label>
            <div class="d-flex flex-wrap">
              <?php $__currentLoopData = ['SA','DB','FE','BE','SI','AS']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-check me-3">
                  <input class="form-check-input" type="checkbox" name="types[]" value="<?php echo e($type); ?>" id="type-<?php echo e($type); ?>" <?php echo e(in_array($type, old('types', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label" for="type-<?php echo e($type); ?>"><?php echo e($type); ?></label>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
          <div class="mb-3">
            <label class="form-label">Reminder To</label>
            <select class="form-control" name="reminder_to" required>
              <option value="Client" <?php echo e(old('reminder_to')=='Client' ? 'selected' : ''); ?>>Client</option>
              <option value="Internal PIC" <?php echo e(old('reminder_to')=='Internal PIC' ? 'selected' : ''); ?>>Internal PIC</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Frekuensi Reminder (jam)</label>
            <select class="form-control" name="reminder_frequency_hours" required>
              <?php $__currentLoopData = [4,8,12,24]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($h); ?>" <?php echo e(old('reminder_frequency_hours')==$h ? 'selected' : ''); ?>><?php echo e($h); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Email Tujuan Reminder</label>
            <select class="form-control js-emails" name="reminder_emails[]" multiple data-placeholder="Tambah email...">
              <?php $__currentLoopData = old('reminder_emails', []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($email); ?>" selected><?php echo e($email); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <small class="text-xs text-secondary">Masukkan satu atau lebih email; tekan Enter untuk menambahkan.</small>
          </div>
          <div class="d-flex justify-content-end">
            <a href="<?php echo e(route('stakeholders.index')); ?>" class="btn btn-light me-2">Batal</a>
            <button type="submit" class="btn btn-primary" data-confirm="Simpan reminder baru?">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
<?php $__env->startPush('dashboard'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  $(function() {
    $('.js-emails').select2({
      tags: true,
      tokenSeparators: [',', ';', ' '],
      placeholder: $('.js-emails').data('placeholder') || 'Tambah email...',
      width: '100'
    }).on('select2:select', function (e) {
      var email = e.params.data.id || '';
      var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!re.test(email)) {
        window.showToast && window.showToast('error', 'Format email tidak valid: ' + email);
        var $sel = $(this);
        setTimeout(function(){ 
          var opt = $sel.find('option[value="'+email+'"]');
          opt.prop('selected', false).remove();
          $sel.trigger('change');
        }, 0);
      }
    });
  });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user_type.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/tryprasetyoadi/Documents/cubi/soft-ui-dashboard-laravel/resources/views/stakeholders/create.blade.php ENDPATH**/ ?>