@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Detail Task</h6>
      </div>
      <div class="card-body">
        <div class="mb-3">
          <strong>Nama Task:</strong> {{ $task->name }}
        </div>
        <div class="mb-3">
          <strong>Link GitLab:</strong> 
          @if($task->link_gitlab)
            <a href="{{ $task->link_gitlab }}" target="_blank" class="text-info">{{ $task->link_gitlab }} <i class="fas fa-external-link-alt text-xs ms-1"></i></a>
          @else
            -
          @endif
        </div>
        <div class="mb-3">
          <strong>Status:</strong> {{ $task->status }}
        </div>
        <div class="mb-3">
          <strong>Target Date:</strong> {{ \Illuminate\Support\Carbon::parse($task->target_date)->format('d M Y') }}
        </div>
        <div class="mb-3">
          <strong>Jenis Task:</strong> {{ implode(', ', $task->types ?? []) }}
        </div>
        <div class="mb-3">
          <strong>Frekuensi Reminder (jam):</strong> {{ $task->reminder_frequency_hours }}
        </div>
        <div class="mb-3">
          <strong>Email Tujuan Reminder:</strong> {{ implode(', ', $task->reminder_emails ?? ($task->reminder_email ? [$task->reminder_email] : [])) }}
        </div>
        <div class="mb-3">
          <strong>Terakhir Reminder:</strong> {{ $task->last_reminded_at ? \Illuminate\Support\Carbon::parse($task->last_reminded_at)->format('d M Y H:i') : '-' }}
        </div>
        <div class="mb-3">
          <strong>Tanggal Pencatatan:</strong> {{ $task->recorded_at ? \Illuminate\Support\Carbon::parse($task->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($task->created_at)->format('d M Y') }}
        </div>
        <div class="d-flex justify-content-end">
          <a href="{{ route('tasks.index') }}" class="btn btn-light">Kembali</a>
          @can('manage-tasks')
          <a href="{{ route('tasks.edit', $task) }}" class="btn btn-primary ms-2" data-confirm="Masuk ke halaman edit task?">Edit</a>
          @endcan
        </div>
      </div>
    </div>
  </div>
@endsection
