@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Edit Task</h6>
      </div>
      <div class="card-body">
        <form method="POST" action="{{ route('tasks.update', $task) }}">
          @csrf
          @method('PUT')
          <div class="mb-3">
            <label class="form-label">Nama Task</label>
            <input type="text" class="form-control" name="name" value="{{ old('name', $task->name) }}" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Link Gitlab</label>
            <input type="url" class="form-control" name="link_gitlab" value="{{ old('link_gitlab', $task->link_gitlab) }}" placeholder="https://gitlab.com/...">
          </div>
          <div class="mb-3">
            <label class="form-label">Target Date</label>
            <input type="date" class="form-control" name="target_date" value="{{ old('target_date', $task->target_date ? $task->target_date->format('Y-m-d') : now()->format('Y-m-d')) }}" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Jenis Task</label>
            <div class="d-flex flex-wrap">
              @php $selected = old('types', $task->types ?? []); @endphp
              @foreach(['SA','DB','FE','BE','SI','AS'] as $type)
                <div class="form-check me-3">
                  <input class="form-check-input" type="checkbox" name="types[]" value="{{ $type }}" id="type-{{ $type }}" {{ in_array($type, $selected) ? 'checked' : '' }}>
                  <label class="form-check-label" for="type-{{ $type }}">{{ $type }}</label>
                </div>
              @endforeach
            </div>
          </div>
          <div class="mb-3">
            <label class="form-label">Status Task</label>
            <select class="form-control" name="status" required>
              @foreach(['Tersampaikan','Sedang Dikerjakan','Selesai'] as $st)
                <option value="{{ $st }}" {{ old('status', $task->status)==$st ? 'selected' : '' }}>{{ $st }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Frekuensi Reminder (jam)</label>
            <select class="form-control" name="reminder_frequency_hours" required>
              @foreach([4,8,12,24] as $h)
                <option value="{{ $h }}" {{ old('reminder_frequency_hours', $task->reminder_frequency_hours)==$h ? 'selected' : '' }}>{{ $h }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Email Tujuan Reminder</label>
            <select class="form-control js-emails" name="reminder_emails[]" multiple data-placeholder="Tambah email...">
              @php $emails = old('reminder_emails', $task->reminder_emails ?? ($task->reminder_email ? [$task->reminder_email] : [])); @endphp
              @foreach($emails as $email)
                <option value="{{ $email }}" selected>{{ $email }}</option>
              @endforeach
            </select>
            <small class="text-xs text-secondary">Masukkan satu atau lebih email; tekan Enter untuk menambahkan.</small>
          </div>
          <div class="d-flex justify-content-end">
            <a href="{{ route('tasks.index') }}" class="btn btn-light me-2">Batal</a>
            <button type="submit" class="btn btn-primary" data-confirm="Simpan perubahan task?">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@push('dashboard')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container {
        width: 100% !important;
    }
    .select2-selection {
        border: 1px solid #d2d6da !important;
        border-radius: 0.5rem !important;
        padding: 0.25rem !important;
        height: auto !important;
        min-height: 40px;
    }
    .select2-selection__arrow {
        height: 38px !important;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  $(function() {
    $('.js-emails').select2({
      tags: true,
      tokenSeparators: [',', ';', ' '],
      placeholder: $('.js-emails').data('placeholder') || 'Tambah email...',
      width: '100'
    }).on('select2:select', function (e) {
      var email = e.params.data.id || '';
      var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!re.test(email)) {
        window.showToast && window.showToast('error', 'Format email tidak valid: ' + email);
        var $sel = $(this);
        setTimeout(function(){ 
          var opt = $sel.find('option[value="'+email+'"]');
          opt.prop('selected', false).remove();
          $sel.trigger('change');
        }, 0);
      }
    });
  });
</script>
@endpush
@endsection
