@extends('layouts.user_type.auth')

@section('content')
<div class="row mb-3">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Reminder Stakeholder</h6>
      </div>
      <div class="card-body">
        <form method="GET" action="{{ route('stakeholders.index') }}" class="row g-3">
          <div class="col-md-3">
            <label class="form-label">Status</label>
            <select class="form-control" name="status">
              <option value="">Semua</option>
              <option value="Sedang Dikerjakan" {{ request('status')=='Sedang Dikerjakan'?'selected':'' }}>Sedang Dikerjakan</option>
              <option value="Selesai" {{ request('status')=='Selesai'?'selected':'' }}>Selesai</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Reminder To</label>
            <select class="form-control" name="reminder_to">
              <option value="">Semua</option>
              <option value="Client" {{ request('reminder_to')=='Client'?'selected':'' }}>Client</option>
              <option value="Internal PIC" {{ request('reminder_to')=='Internal PIC'?'selected':'' }}>Internal PIC</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Bulan</label>
            <input type="month" class="form-control" name="month" value="{{ request('month') }}">
          </div>
          <div class="col-md-3">
            <label class="form-label">Cari</label>
            <input type="text" class="form-control" name="q" value="{{ request('q') }}" placeholder="Nama, Email, Status atau Kode Jenis">
          </div>
          <div class="col-md-12 d-flex align-items-end justify-content-md-end gap-2 flex-wrap">
            <button class="btn bg-gradient-primary btn-sm mb-0" type="submit">Filter</button>
            <a href="{{ route('stakeholders.index') }}" class="btn btn-outline-secondary btn-sm mb-0">Reset</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header pb-0 px-3">
        <div class="d-flex justify-content-end gap-2">
          <a href="{{ route('stakeholders.create') }}" class="btn bg-gradient-success btn-sm mb-0">Tambah Reminder</a>
        </div>
      </div>
      <div class="card-body px-0 pb-2">
        <div class="table-responsive">
          <table class="table table-striped table-hover align-items-center mb-0">
            <thead>
              <tr>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Judul</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Status</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Target</th>
                <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Aksi</th>
              </tr>
            </thead>
            <tbody>
              @forelse($items as $item)
                <tr>
                  <td>
                    <div class="d-flex flex-column">
                      <span class="text-sm font-weight-bold">{{ $item->name }}</span>
                      <div class="mt-2 text-xs text-secondary">
                        <span class="me-2">{{ $item->reminder_to }}</span>
                        <i class="ni ni-time-alarm"></i> {{ $item->reminder_frequency_hours }} jam
                        <span class="ms-2"><i class="ni ni-email-83"></i> {{ implode(', ', $item->reminder_emails ?? []) }}</span>
                      </div>
                      <div class="text-xxs text-secondary">
                        Terakhir: {{ $item->last_reminded_at ? \Illuminate\Support\Carbon::parse($item->last_reminded_at)->format('d M Y H:i') : '-' }}
                        <span class="ms-2">Dicatat: {{ $item->recorded_at ? \Illuminate\Support\Carbon::parse($item->recorded_at)->format('d M Y') : \Illuminate\Support\Carbon::parse($item->created_at)->format('d M Y') }}</span>
                      </div>
                    </div>
                  </td>
                  <td>
                    @php
                      $statusColor = $item->status === 'Selesai' ? 'success' : ($item->status === 'Sedang Dikerjakan' ? 'warning' : 'secondary');
                    @endphp
                    <span class="badge badge-sm bg-gradient-{{ $statusColor }}">{{ $item->status }}</span>
                  </td>
                  <td>{{ \Illuminate\Support\Carbon::parse($item->target_date)->format('d M Y') }}</td>
                  <td>
                    <a href="{{ route('stakeholders.show', $item) }}" class="btn btn-sm bg-gradient-info me-2">Detail</a>
                    <a href="{{ route('stakeholders.edit', $item) }}" class="btn btn-sm bg-gradient-primary" data-confirm="Masuk ke halaman edit reminder?">Edit</a>
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="9" class="text-center text-secondary">Tidak ada data.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
        <div class="px-3 mt-3 d-flex justify-content-end">
          {{ $items->links() }}
        </div>
      </div>
    </div>
  </div>
</div>
<style>
.pagination .page-link {
  border-radius: .5rem;
}
</style>
@endsection
