@extends('layouts.user_type.auth')

@section('content')
<div class="row">
  <div class="col-md-8 mx-auto">
    <div class="card">
      <div class="card-header pb-0">
        <h6>Edit Reminder Stakeholder</h6>
      </div>
      <div class="card-body">
        <form method="POST" action="{{ route('stakeholders.update', $item) }}">
          @csrf
          @method('PUT')
          <div class="mb-3">
            <label class="form-label">Judul</label>
            <input type="text" class="form-control" name="name" value="{{ old('name', $item->name) }}" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Target Date</label>
            <input type="date" class="form-control" name="target_date" value="{{ old('target_date', $item->target_date ? $item->target_date->format('Y-m-d') : now()->format('Y-m-d')) }}" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Status</label>
            <select class="form-control" name="status" required>
              @foreach(['Sedang Dikerjakan','Selesai'] as $st)
                <option value="{{ $st }}" {{ old('status', $item->status)==$st ? 'selected' : '' }}>{{ $st }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Reminder To</label>
            <select class="form-control" name="reminder_to" required>
              <option value="Client" {{ old('reminder_to', $item->reminder_to)=='Client' ? 'selected' : '' }}>Client</option>
              <option value="Internal PIC" {{ old('reminder_to', $item->reminder_to)=='Internal PIC' ? 'selected' : '' }}>Internal PIC</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Frekuensi Reminder (jam)</label>
            <select class="form-control" name="reminder_frequency_hours" required>
              @foreach([4,8,12,24] as $h)
                <option value="{{ $h }}" {{ old('reminder_frequency_hours', $item->reminder_frequency_hours)==$h ? 'selected' : '' }}>{{ $h }}</option>
              @endforeach
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Email Tujuan Reminder</label>
            <select class="form-control js-emails" name="reminder_emails[]" multiple data-placeholder="Tambah email...">
              @php $emails = old('reminder_emails', $item->reminder_emails ?? []); @endphp
              @foreach($emails as $email)
                <option value="{{ $email }}" selected>{{ $email }}</option>
              @endforeach
            </select>
            <small class="text-xs text-secondary">Masukkan satu atau lebih email; tekan Enter untuk menambahkan.</small>
          </div>
          <div class="d-flex justify-content-end">
            <a href="{{ route('stakeholders.index') }}" class="btn btn-light me-2">Batal</a>
            <button type="submit" class="btn btn-primary" data-confirm="Simpan perubahan reminder?">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@push('dashboard')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container {
        width: 100% !important;
    }
    .select2-selection {
        border: 1px solid #d2d6da !important;
        border-radius: 0.5rem !important;
        padding: 0.25rem !important;
        height: auto !important;
        min-height: 40px;
    }
    .select2-selection__arrow {
        height: 38px !important;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  $(function() {
    $('.js-emails').select2({
      tags: true,
      tokenSeparators: [',', ';', ' '],
      placeholder: $('.js-emails').data('placeholder') || 'Tambah email...',
      width: '100'
    }).on('select2:select', function (e) {
      var email = e.params.data.id || '';
      var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!re.test(email)) {
        window.showToast && window.showToast('error', 'Format email tidak valid: ' + email);
        var $sel = $(this);
        setTimeout(function(){ 
          var opt = $sel.find('option[value="'+email+'"]');
          opt.prop('selected', false).remove();
          $sel.trigger('change');
        }, 0);
      }
    });
  });
</script>
@endpush
@endsection
