<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('stakeholder_reminders', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->date('target_date');
            $table->enum('status', ['Sedang Dikerjakan', 'Selesai'])->default('Sedang Dikerjakan');
            $table->enum('reminder_to', ['Client', 'Internal PIC']);
            $table->unsignedInteger('reminder_frequency_hours')->default(24);
            $table->json('reminder_emails');
            $table->timestamp('last_reminded_at')->nullable();
            $table->date('recorded_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stakeholder_reminders');
    }
};
