<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class StakeholderReminder extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'target_date',
        'status',
        'reminder_to',
        'reminder_frequency_hours',
        'reminder_emails',
        'last_reminded_at',
        'recorded_at',
    ];

    protected $casts = [
        'target_date' => 'date',
        'last_reminded_at' => 'datetime',
        'recorded_at' => 'date',
        'reminder_emails' => 'array',
    ];

    protected static function booted(): void
    {
        static::creating(function (StakeholderReminder $r) {
            if (empty($r->status)) {
                $r->status = 'Sedang Dikerjakan';
            }
            if (empty($r->recorded_at)) {
                $r->recorded_at = Carbon::now()->toDateString();
            }
        });
    }
}
