<?php

namespace App\Mail;

use App\Models\Task;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TaskReminderMail extends Mailable
{
    use Queueable, SerializesModels;

    public Task $task;

    public function __construct(Task $task)
    {
        $this->task = $task;
        $this->subject('[DJPS TASK REMINDER] ' . $task->name);
    }

    public function build()
    {
        return $this->view('emails.task_reminder')
            ->with([
                'task' => $this->task,
            ]);
    }
}

